# -*- coding:utf-8 -*-
from django.core.management.base import BaseCommand
from django.core.mail.message import EmailMessage
from django.core.mail import get_connection
from django.template import loader
import json
import datetime
from ooredis import *
from base.email_setting import get_cfg_options
import os
__author__ = 'Arvin'


def print_debug(msg):
    from mysite.settings import DEBUG
    if DEBUG:
        print msg
    pass


def send_email(subject, message, recipient_list, path=None,
               fail_silently=False, connection=None, content_subtype='html'):
    mail_cfg = get_cfg_options()
    connection = connection or get_connection(host=mail_cfg['email_host'],
                                              port=mail_cfg['email_port'],
                                              username=mail_cfg['email_host_user'],
                                              password=mail_cfg['email_host_password'],
                                              use_tls=mail_cfg['email_use_tls'],
                                              fail_silently=fail_silently)
    try:
        # from_email = mail_cfg['email_host_user']
        from_email = mail_cfg['sender_name']
        headers = {
            'From': mail_cfg['sender_name']
        }
        em = EmailMessage(subject=subject, body=message, from_email=from_email,
                          to=recipient_list, connection=connection, headers=headers)
        if path:
            print_debug("[*]File path %s" % path)
            em.attach_file(path)
        em.content_subtype = content_subtype
        ret = em.send()
    except Exception, e:
        import traceback
        import time
        traceback.print_exc()
        ret = 0
        time.sleep(60)
    return ret


def file_rename(subject, path):
    from django.utils.translation import ugettext
    import os
    import datetime
    import time
    if path:
        now = datetime.datetime.now()
        filename = path.replace('\\', '/').split('/')[-1]
        timestr = time.mktime(now.timetuple())
        filename = filename.split('.')[0]
        new_file_path = path.replace(filename, ugettext(u'%s(%s)') % (subject, timestr)).encode('gb18030')
        if os.path.exists(new_file_path):
            os.remove(new_file_path)
        os.rename(path, new_file_path)
        path = new_file_path
    return path


def remove_email(key):
    Dict('email:%s:detail' % key).delete()
    Set('pending_emails').remove(key)


def email_handle():
    import time
    from django.db import close_connection, reset_queries
    while True:
        try:
            pending_emails = Set('pending_emails').sscan_iter()
            emails = [e for i, e in enumerate(pending_emails) if i < 5]
            if emails:
                for key in emails:
                    email = Dict('email:%s:detail' % key)
                    if not email.exists:
                        remove_email(key)
                        continue
                    try:
                        subject = email['subject']
                        receiver = email['receiver']
                        keep_file = email.get('keep_file', False)
                        email_template = email['email_template']
                        path = email['path'].strip()
                        params = json.loads(email['params'])
                        if path:
                            if not os.path.exists(path):
                                print_debug("[*]The file(%s) lost." % path)
                                remove_email(key)
                                continue
                            if not keep_file:
                                path = file_rename(subject, path)
                            ret = send_email(subject, params, [receiver], path=path, content_subtype='plain')
                        else:
                            if email_template:
                                context = loader.render_to_string(email_template, params)
                            else:
                                context = params
                            ret = send_email(subject, context, [receiver], path=path)
                    except ValueError, e:
                        print_debug("[*]Email Parse Error: %s -->(Subject:%s, Params:%s, Receiver:%s, Path:%s) " %
                                    (e, email['subject'], email['params'], email['receiver'], email['path']))
                        remove_email(key)
                        continue
                    if ret:
                        remove_email(key)
                        if path and not keep_file:
                            os.remove(path)
                        print_debug("[*]Send success %s email(s), Receiver:%s" % (ret, receiver))
                    else:
                        print_debug("[*]Email exception [subject]: %s [receiver]: %s  [time]:%s" % (subject, receiver, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')))
            reset_queries()
            time.sleep(1)
        except Exception, e:
            import traceback
            traceback.print_exc()
            print_debug("[*]Email Handle Error: %s " % e)
            close_connection()
            time.sleep(30)
            raise e


class Command(BaseCommand):
    option_list = BaseCommand.option_list + ()
    help = "Start SMTP Service."
    args = ''

    def handle(self, *args, **options):
        email_handle()
